﻿<%@ Page Language="c#" AutoEventWireup="false" CodePage="1200" %>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Handel" %>
<%@ Import Namespace="Soneta.Towary" %>
<%@ Import Namespace="Soneta.Magazyny" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
    <title>Marża wg towarów</title>

    <script runat="server">

        public class ParametryContext : ContextBase
        {
            public ParametryContext(Context cx)
                : base(cx)
            {
            }

            bool storna = false;

            public bool PokazujStorna
            {
                get { return storna; }
                set { storna = value; }
            }
        }

        ParametryContext parametry;

        [Context]
        public ParametryContext Parametry
        {
            get { return parametry; }
            set { parametry = value; }
        }

        void Grid_ItemsGet(Object sender, ItemsGetEventArgs args)
        {
            if (args.Deep == 1)
            {
                Soneta.Magazyny.ObrotyParams pars = (Soneta.Magazyny.ObrotyParams)
                    dc[typeof(Soneta.Magazyny.ObrotyParams)];

                Towar t = (Towar)args.Row;
                Magazyn m = pars.Magazyn;

                SubTable st;
                if (pars.OkresCzasu == FromTo.All)
                    st = t.Module.Magazyny.Obroty.WgTowar[t, m];
                else
                    st = new SubTable(t.Module.Magazyny.Obroty.WgTowar[t, m], pars.OkresCzasu);

                args.Enumerable = st;

                nr = 0;
            }
        }

        int nr = 0;

        void Grid_BeforeRow(Object sender, RowEventArgs args)
        {
            Obrot o = (Obrot)args.Row;
            if (!Parametry.PokazujStorna)
                args.VisibleRow = o.Korekta != KorektaObrotu.StornoZasobu;
            colIlosc.SumRow = o.Korekta != KorektaObrotu.Ilości;
            if (args.VisibleRow)
                lp.EditValue = ++nr;
        }

        void OnContextLoad(Object sender, EventArgs args)
        {
            Soneta.Magazyny.ObrotyParams pars = (Soneta.Magazyny.ObrotyParams)dc[typeof(Soneta.Magazyny.ObrotyParams)];
            if (pars.Kontrahent != null)
                ReportHeader.Title += "|Kontrahent: <strong>" + pars.Kontrahent.ToString() + "</strong>";
        }

    </script>

    <meta content="C#" name="CODE_LANGUAGE">
    <meta content="JavaScript" name="vs_defaultClientScript">
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
</head>
<body>
    <form method="post" runat="server">
        <ea:DataContext ID="dc" runat="server" OnContextLoad="OnContextLoad"></ea:DataContext>
        <eb:ReportHeader ID="ReportHeader" Title="Marża wg towarów - szczegóły|</STRONG>Magazyn:<STRONG> {0}|</STRONG>Okres:<STRONG> {1}</STRONG>"
            runat="server" DataMember0="ObrotyParams.Magazyn" DataMember1="ObrotyParams.OkresCzasu"></eb:ReportHeader>
        <ea:Grid ID="Grid" runat="server" OnBeforeRow="Grid_BeforeRow" ShowGroupSum="True"
            GroupLine="Towar: {0} - {1}" GroupData1="Towar.Nazwa" GroupData0="Towar.Kod"
            OnItemsGet="Grid_ItemsGet" RowTypeName="Soneta.Magazyny.Obrot,Soneta.Handel">
            <Columns>
                <ea:GridColumn Width="4" Align="Right" Caption="LP." ID="lp" EncodeHTML="True" runat="server">
                </ea:GridColumn>
                <ea:GridColumn DataMember="Korekta" Total="Info" Caption="Typ" EncodeHTML="True"
                    runat="server">
                </ea:GridColumn>
                <ea:GridColumn Width="10" Align="Right" DataMember="Ilosc" Total="Sum" Caption="Ilość"
                    HideZero="True" Format="{0:n}" ID="colIlosc" EncodeHTML="True" runat="server">
                </ea:GridColumn>
                <ea:GridColumn Width="10" Align="Right" DataMember="Przychod.Wartosc" Total="Sum"
                    Caption="Przych&#243;d~wartość" HideZero="True" Format="{0:n}" EncodeHTML="True"
                    runat="server">
                </ea:GridColumn>
                <ea:GridColumn Width="14" DataMember="Przychod.Dokument.Numer" Caption="Przych&#243;d~dokument"
                    EncodeHTML="True" runat="server">
                </ea:GridColumn>
                <ea:GridColumn Width="10" DataMember="Przychod.Data" Caption="Przych&#243;d~data"
                    EncodeHTML="True" runat="server">
                </ea:GridColumn>
                <ea:GridColumn Width="10" Align="Right" DataMember="Rozchod.Wartosc" Total="Sum"
                    Caption="Rozch&#243;d~wartość" HideZero="True" Format="{0:n}" EncodeHTML="True"
                    runat="server">
                </ea:GridColumn>
                <ea:GridColumn Width="14" DataMember="Rozchod.Dokument.Numer" Caption="Rozch&#243;d~dokument"
                    EncodeHTML="True" runat="server">
                </ea:GridColumn>
                <ea:GridColumn Width="10" DataMember="Rozchod.Data" Caption="Rozch&#243;d~data" EncodeHTML="True"
                    runat="server">
                </ea:GridColumn>
                <ea:GridColumn Width="10" Align="Right" DataMember="Marża" Total="Sum" Caption="Marża~Wartość"
                    HideZero="True" Format="{0:n}" EncodeHTML="True" runat="server">
                </ea:GridColumn>
                <ea:GridColumn Width="6" Align="Right" DataMember="ProcentMarży" Caption="Marża~%"
                    Format="{0:n}" EncodeHTML="True" runat="server">
                </ea:GridColumn>
                <ea:GridColumn Width="9" Align="Right" DataMember="MarżaJednostkowa" Caption="Marża~Jednost."
                    Format="{0:n}" EncodeHTML="True" runat="server">
                </ea:GridColumn>
            </Columns>
        </ea:Grid>
        <eb:ReportFooter ID="ReportFooter" runat="server" PrintDate="true" PrintTime="true">
        </eb:ReportFooter>
    </form>
</body>
</html>

